<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Values;
abstract class ApproveChallengeModels
{
    /**
     * @property string $authenticatorData The [authenticator data](https://developer.mozilla.org/en-US/docs/Web/API/Web_Authentication_API/Authenticator_data) structure contains information from the authenticator about the processing of a credential creation or authentication request.
     * @property string $clientDataJSON This property contains the JSON-compatible serialization of the data passed from the browser to the authenticator in order to generate this credential.
     * @property string $signature An assertion signature over `authenticatorData` and `clientDataJSON`. The assertion signature is created with the private key of the key pair that was created during the originating `navigator.credentials.create()` call and verified using the public key of that same key pair.
     * @property string $userHandle The user handle stored in the authenticator, specified as `user.id` in the options passed to the originating `navigator.credentials.create()` call. This property should contain a base64url-encoded entity SID.
    */
    public static function createApprovePasskeysChallengeRequestResponse(array $payload = []): ApprovePasskeysChallengeRequestResponse
    {
        return new ApprovePasskeysChallengeRequestResponse($payload);
    }

    /**
     * @property string $id A [base64url](https://base64.guru/standards/base64url) encoded representation of `rawId`.
     * @property string $rawId The globally unique identifier for this `PublicKeyCredential`.
     * @property string $authenticatorAttachment A string that indicates the mechanism by which the WebAuthn implementation is attached to the authenticator at the time the associated `navigator.credentials.create()` or `navigator.credentials.get()` call completes.
     * @property string $type The valid credential types supported by the API. The values of this enumeration are used for versioning the `AuthenticatorAssertion` and `AuthenticatorAttestation` structures according to the type of the authenticator.
     * @property ApprovePasskeysChallengeRequestResponse $response
    */
    public static function createApprovePasskeysChallengeRequest(array $payload = []): ApprovePasskeysChallengeRequest
    {
        return new ApprovePasskeysChallengeRequest($payload);
    }

}

class ApprovePasskeysChallengeRequestResponse implements \JsonSerializable
{
    /**
     * @property string $authenticatorData The [authenticator data](https://developer.mozilla.org/en-US/docs/Web/API/Web_Authentication_API/Authenticator_data) structure contains information from the authenticator about the processing of a credential creation or authentication request.
     * @property string $clientDataJSON This property contains the JSON-compatible serialization of the data passed from the browser to the authenticator in order to generate this credential.
     * @property string $signature An assertion signature over `authenticatorData` and `clientDataJSON`. The assertion signature is created with the private key of the key pair that was created during the originating `navigator.credentials.create()` call and verified using the public key of that same key pair.
     * @property string $userHandle The user handle stored in the authenticator, specified as `user.id` in the options passed to the originating `navigator.credentials.create()` call. This property should contain a base64url-encoded entity SID.
    */
        protected $authenticatorData;
        protected $clientDataJSON;
        protected $signature;
        protected $userHandle;
    public function __construct(array $payload = []) {
        $this->authenticatorData = Values::array_get($payload, 'authenticatorData');
        $this->clientDataJSON = Values::array_get($payload, 'clientDataJSON');
        $this->signature = Values::array_get($payload, 'signature');
        $this->userHandle = Values::array_get($payload, 'userHandle');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'authenticatorData' => $this->authenticatorData,
            'clientDataJSON' => $this->clientDataJSON,
            'signature' => $this->signature
        ];
        if (isset($this->userHandle)) {
            $jsonString['userHandle'] = $this->userHandle;
        }
        return $jsonString;
    }
}

class ApprovePasskeysChallengeRequest implements \JsonSerializable
{
    /**
     * @property string $id A [base64url](https://base64.guru/standards/base64url) encoded representation of `rawId`.
     * @property string $rawId The globally unique identifier for this `PublicKeyCredential`.
     * @property string $authenticatorAttachment A string that indicates the mechanism by which the WebAuthn implementation is attached to the authenticator at the time the associated `navigator.credentials.create()` or `navigator.credentials.get()` call completes.
     * @property string $type The valid credential types supported by the API. The values of this enumeration are used for versioning the `AuthenticatorAssertion` and `AuthenticatorAttestation` structures according to the type of the authenticator.
     * @property ApprovePasskeysChallengeRequestResponse $response
    */
        protected $id;
        protected $rawId;
        protected $authenticatorAttachment;
        protected $type;
        protected $response;
    public function __construct(array $payload = []) {
        $this->id = Values::array_get($payload, 'id');
        $this->rawId = Values::array_get($payload, 'rawId');
        $this->authenticatorAttachment = Values::array_get($payload, 'authenticatorAttachment');
        $this->type = Values::array_get($payload, 'type');
        $this->response = Values::array_get($payload, 'response');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'id' => $this->id,
            'rawId' => $this->rawId,
            'authenticatorAttachment' => $this->authenticatorAttachment,
            'response' => $this->response
        ];
        if (isset($this->type)) {
            $jsonString['type'] = $this->type;
        }
        return $jsonString;
    }
}

