<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Values;
abstract class NewVerifyFactorModels
{
    /**
     * @property string $attestationObject The authenticator data and an attestation statement for a new key pair generated by the authenticator.
     * @property string $clientDataJSON This property contains the JSON-compatible serialization of the data passed from the browser to the authenticator in order to generate this credential.
     * @property string[][] $transports An array of strings providing hints as to the methods the client could use to communicate with the relevant authenticator of the public key credential to retrieve.
    */
    public static function createVerifyPasskeysFactorRequestResponse(array $payload = []): VerifyPasskeysFactorRequestResponse
    {
        return new VerifyPasskeysFactorRequestResponse($payload);
    }

    /**
     * @property string $id A [base64url](https://base64.guru/standards/base64url) encoded representation of `rawId`.
     * @property string $rawId The globally unique identifier for this `PublicKeyCredential`.
     * @property string $authenticatorAttachment A string that indicates the mechanism by which the WebAuthn implementation is attached to the authenticator at the time the associated  `navigator.credentials.create()` or `navigator.credentials.get()` call completes.
     * @property string $type The valid credential types supported by the API. The values of this enumeration are used for versioning the `AuthenticatorAssertion` and `AuthenticatorAttestation` structures according to the type of the authenticator.
     * @property VerifyPasskeysFactorRequestResponse $response
    */
    public static function createVerifyPasskeysFactorRequest(array $payload = []): VerifyPasskeysFactorRequest
    {
        return new VerifyPasskeysFactorRequest($payload);
    }

}

class VerifyPasskeysFactorRequestResponse implements \JsonSerializable
{
    /**
     * @property string $attestationObject The authenticator data and an attestation statement for a new key pair generated by the authenticator.
     * @property string $clientDataJSON This property contains the JSON-compatible serialization of the data passed from the browser to the authenticator in order to generate this credential.
     * @property string[][] $transports An array of strings providing hints as to the methods the client could use to communicate with the relevant authenticator of the public key credential to retrieve.
    */
        protected $attestationObject;
        protected $clientDataJSON;
        protected $transports;
    public function __construct(array $payload = []) {
        $this->attestationObject = Values::array_get($payload, 'attestationObject');
        $this->clientDataJSON = Values::array_get($payload, 'clientDataJSON');
        $this->transports = Values::array_get($payload, 'transports');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->attestationObject)) {
            $jsonString['attestationObject'] = $this->attestationObject;
        }
        if (isset($this->clientDataJSON)) {
            $jsonString['clientDataJSON'] = $this->clientDataJSON;
        }
        if (isset($this->transports)) {
            $jsonString['transports'] = $this->transports;
        }
        return $jsonString;
    }
}

class VerifyPasskeysFactorRequest implements \JsonSerializable
{
    /**
     * @property string $id A [base64url](https://base64.guru/standards/base64url) encoded representation of `rawId`.
     * @property string $rawId The globally unique identifier for this `PublicKeyCredential`.
     * @property string $authenticatorAttachment A string that indicates the mechanism by which the WebAuthn implementation is attached to the authenticator at the time the associated  `navigator.credentials.create()` or `navigator.credentials.get()` call completes.
     * @property string $type The valid credential types supported by the API. The values of this enumeration are used for versioning the `AuthenticatorAssertion` and `AuthenticatorAttestation` structures according to the type of the authenticator.
     * @property VerifyPasskeysFactorRequestResponse $response
    */
        protected $id;
        protected $rawId;
        protected $authenticatorAttachment;
        protected $type;
        protected $response;
    public function __construct(array $payload = []) {
        $this->id = Values::array_get($payload, 'id');
        $this->rawId = Values::array_get($payload, 'rawId');
        $this->authenticatorAttachment = Values::array_get($payload, 'authenticatorAttachment');
        $this->type = Values::array_get($payload, 'type');
        $this->response = Values::array_get($payload, 'response');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'response' => $this->response
        ];
        if (isset($this->id)) {
            $jsonString['id'] = $this->id;
        }
        if (isset($this->rawId)) {
            $jsonString['rawId'] = $this->rawId;
        }
        if (isset($this->authenticatorAttachment)) {
            $jsonString['authenticatorAttachment'] = $this->authenticatorAttachment;
        }
        if (isset($this->type)) {
            $jsonString['type'] = $this->type;
        }
        return $jsonString;
    }
}

