document.addEventListener('DOMContentLoaded', function () {
    const container = document.getElementById('templates-container');
    const filterBtns = document.querySelectorAll('.filter-btn');
    let currentCategory = 'all';

    // Cargar plantillas
    function loadTemplates(category) {
        container.innerHTML = '<div class="text-center"><div class="spinner-border text-primary" role="status"></div></div>';
        
        fetch(`api/get_templates.php?category=${category}`)
            .then(res => res.json())
            .then(templates => {
                container.innerHTML = '';
                if (templates.length === 0) {
                    container.innerHTML = '<p class="text-center">No hay plantillas en esta categoría.</p>';
                    return;
                }

                templates.forEach(t => {
                    const col = document.createElement('div');
                    col.className = 'col-md-4 mb-4';
                    col.innerHTML = `
                        <div class="card h-100">
                            <img src="assets/img/thumbnails/${t.thumbnail}" class="card-img-top" alt="${t.title}">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">${t.title}</h5>
                                <p class="text-muted">${t.category.toUpperCase()}</p>
                                <p class="mt-auto"><strong>$${t.price}</strong></p>
                                <button class="btn btn-primary mt-2 preview-btn" 
                                        data-id="${t.id}" 
                                        data-title="${t.title}" 
                                        data-img="${t.thumbnail}"
                                        data-price="${t.price}">
                                    Ver Demo
                                </button>
                            </div>
                        </div>
                    `;
                    container.appendChild(col);
                });

                // Activar modales
                document.querySelectorAll('.preview-btn').forEach(btn => {
                    btn.addEventListener('click', function () {
                        const modal = new bootstrap.Modal(document.getElementById('previewModal'));
                        document.getElementById('modalTitle').textContent = this.dataset.title;
                        document.getElementById('modalImage').src = `assets/img/thumbnails/${this.dataset.img}`;
                        document.getElementById('modalPrice').innerHTML = `<strong>Precio: $${this.dataset.price}</strong>`;
                        modal.show();
                    });
                });
            });
    }

    // Filtros
    filterBtns.forEach(btn => {
        btn.addEventListener('click', function () {
            filterBtns.forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            currentCategory = this.dataset.category;
            loadTemplates(currentCategory);
        });
    });

    // Cargar inicial
    loadTemplates('all');
});