<?php require_once 'includes/config.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>InvitaDigital | Invitaciones Animadas Premium</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="assets/css/style-premium.css" rel="stylesheet">
    <link rel="icon" href="assets/img/favicon.png">
</head>
<body>

<!-- HERO CON VIDEO DE FONDO -->
<section class="hero-section position-relative overflow-hidden">
    <video autoplay muted loop playsinline class="hero-video">
        <source src="https://assets.mixkit.co/videos/preview/mixkit-set-of-plateaus-seen-from-the-heights-in-a-sunset-26070-large.mp4" type="video/mp4">
    </video>
    <div class="hero-overlay"></div>
    <div class="container position-relative z-3 text-center text-white py-5">
        <h1 class="display-3 fw-bold mb-4" data-aos="fade-up">
            Tus <span class="text-gradient">Invitaciones</span> Digitales
        </h1>
        <p class="lead mb-5" data-aos="fade-up" data-aos-delay="200">
            Personalizables, animadas y enviadas por WhatsApp en segundos
        </p>
        <a href="#galeria" class="btn btn-warning btn-lg px-5 py-3 shadow-lg" data-aos="zoom-in" data-aos-delay="400">
            Explora Modelos
        </a>
    </div>
</section>

<!-- FILTROS + GALERÍA PREMIUM -->
<section class="py-5" id="galeria">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2 class="display-5 fw-bold text-gradient">Elige tu estilo perfecto</h2>
            <p class="text-muted">Más de 100 plantillas animadas listas para personalizar</p>
        </div>

        <!-- Filtros con estilo -->
        <div class="text-center mb-5" data-aos="fade-up" data-aos-delay="100">
            <div class="btn-group-shadow">
                <button class="btn btn-filter active" data-category="all">Todos</button>
                <button class="btn btn-filter" data-category="boda">Bodas</button>
                <button class="btn btn-filter" data-category="xv">XV Años</button>
                <button class="btn btn-filter" data-category="cumple">Cumpleaños</button>
                <button class="btn btn-filter" data-category="bautizo">Bautizos</button>
            </div>
        </div>

        <!-- Galería 3D -->
        <div class="row g-4" id="templates-container">
            <div class="text-center py-5">
                <div class="spinner-border text-warning" style="width: 3rem; height: 3rem;"></div>
            </div>
        </div>
    </div>
</section>

<!-- MODAL PREMIUM -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content overflow-hidden rounded-4 shadow-lg">
            <div class="modal-body p-0">
                <div class="position-relative">
                    <img id="modalImage" src="" class="img-fluid w-100" style="max-height: 80vh; object-fit: contain;">
                    <div class="position-absolute top-0 end-0 p-3">
                        <button type="button" class="btn-close btn-close-white shadow" data-bs-dismiss="modal"></button>
                    </div>
                </div>
                <div class="p-4 bg-gradient text-white">
                    <h3 id="modalTitle" class="mb-2"></h3>
                    <p id="modalPrice" class="fs-4 fw-bold mb-3"></p>
                    <a id="editLink" href="#" class="btn btn-light btn-lg px-5">
                        Personalizar Ahora
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- BOTÓN FLOTANTE -->
<a href="#galeria" class="floating-btn shadow-lg">
    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
        <path d="M8 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L7.5 2.707V14.5a.5.5 0 0 0 .5.5z"/>
    </svg>
</a>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="assets/js/main-premium.js"></script>
<script>
    AOS.init({ duration: 1000, once: true });
</script>
</body>
</html>